/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.container;

import dev.toma.gunsrpg.common.container.AbstractModContainer;
import dev.toma.gunsrpg.common.init.ModContainers;
import dev.toma.gunsrpg.common.init.ModRecipeTypes;
import dev.toma.gunsrpg.common.tileentity.BlastFurnaceTileEntity;
import dev.toma.gunsrpg.resource.blasting.BlastingRecipe;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeBookCategory;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ServerRecipePlacerFurnace;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IIntArray;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class BlastFurnaceContainer
extends RecipeBookContainer<IInventory> {
    private final BlastFurnaceTileEntity tileEntity;
    private final World level;
    private final IRecipeType<BlastingRecipe> recipeType = ModRecipeTypes.BLASTING_RECIPE_TYPE;
    private final IIntArray data;

    public BlastFurnaceContainer(int windowID, PlayerInventory inventory, BlastFurnaceTileEntity tileEntity) {
        super((ContainerType)ModContainers.BLAST_FURNACE.get(), windowID);
        this.tileEntity = tileEntity;
        this.level = inventory.field_70458_d.field_70170_p;
        this.data = tileEntity.getData();
        BlastFurnaceContainer.func_216962_a((IInventory)tileEntity, (int)3);
        this.func_75146_a(new Slot((IInventory)tileEntity, 0, 56, 17));
        this.func_75146_a(new FuelSlot(this, tileEntity, 1, 56, 53));
        this.func_75146_a(new OutputSlot(inventory.field_70458_d, tileEntity, 2, 116, 35));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)inventory, 9 + y * 9 + x, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)inventory, x, 8 + x * 18, 142));
        }
    }

    public BlastFurnaceContainer(int windowID, PlayerInventory inventory, PacketBuffer buffer) {
        this(windowID, inventory, (BlastFurnaceTileEntity)((Object)AbstractModContainer.readTileEntity(buffer, inventory)));
    }

    public void func_201771_a(RecipeItemHelper itemHelper) {
        this.tileEntity.func_194018_a(itemHelper);
    }

    public void func_201768_e() {
        this.tileEntity.func_174888_l();
    }

    public void func_217056_a(boolean flag, IRecipe<?> recipe, ServerPlayerEntity player) {
        new ServerRecipePlacerFurnace((RecipeBookContainer)this).func_194327_a(player, recipe, flag);
    }

    public boolean func_201769_a(IRecipe<? super IInventory> recipe) {
        return recipe.func_77569_a((IInventory)this.tileEntity, this.level);
    }

    public int func_201767_f() {
        return 2;
    }

    public int func_201770_g() {
        return 1;
    }

    public int func_201772_h() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_203721_h() {
        return 3;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.tileEntity.func_70300_a(player);
    }

    public RecipeBookCategory func_241850_m() {
        return RecipeBookCategory.FURNACE;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 2) {
                if (!this.func_75135_a(itemstack1, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index != 1 && index != 0 ? (this.isValidInput(itemstack1) ? !this.func_75135_a(itemstack1, 0, 1, false) : (this.isFuel(itemstack1) ? !this.func_75135_a(itemstack1, 1, 2, false) : (index >= 3 && index < 30 ? !this.func_75135_a(itemstack1, 30, 39, false) : index >= 30 && index < 39 && !this.func_75135_a(itemstack1, 3, 30, false)))) : !this.func_75135_a(itemstack1, 3, 39, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }

    public boolean isLit() {
        return this.data.func_221476_a(0) > 0;
    }

    public int getLitProgress() {
        int i = this.data.func_221476_a(1);
        if (i == 0) {
            i = 200;
        }
        return this.data.func_221476_a(0) * 13 / i;
    }

    public int getBurnProgress() {
        int cookProgress = this.data.func_221476_a(2);
        int totalCookProgress = this.data.func_221476_a(3);
        return totalCookProgress != 0 && cookProgress != 0 ? cookProgress * 24 / totalCookProgress : 0;
    }

    boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, this.recipeType) > 0;
    }

    boolean isValidInput(ItemStack stack) {
        RecipeManager manager = this.level.func_199532_z();
        List recipes = manager.func_241447_a_(ModRecipeTypes.BLASTING_RECIPE_TYPE);
        for (BlastingRecipe recipe : recipes) {
            Ingredient ingredient = recipe.getIngredient();
            if (!ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }

    private static class FuelSlot
    extends Slot {
        private final BlastFurnaceContainer container;

        FuelSlot(BlastFurnaceContainer container, IInventory inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            this.container = container;
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.container.isFuel(stack) || FuelSlot.isBucket(stack);
        }

        public int func_178170_b(ItemStack stack) {
            return FuelSlot.isBucket(stack) ? 1 : super.func_178170_b(stack);
        }

        private static boolean isBucket(ItemStack stack) {
            return stack.func_77973_b() == Items.field_151133_ar;
        }
    }

    private static class OutputSlot
    extends Slot {
        private final PlayerEntity interactingPlayer;
        private int takeCount;

        OutputSlot(PlayerEntity interactingPlayer, IInventory inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            this.interactingPlayer = interactingPlayer;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_75209_a(int count) {
            if (this.func_75216_d()) {
                this.takeCount += Math.min(count, this.func_75211_c().func_190916_E());
            }
            return super.func_75209_a(count);
        }

        public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
            this.func_75208_c(stack);
            super.func_190901_a(player, stack);
            return stack;
        }

        protected void func_75210_a(ItemStack stack, int count) {
            this.takeCount += count;
            this.func_75208_c(stack);
        }

        protected void func_75208_c(ItemStack stack) {
            World level = this.interactingPlayer.field_70170_p;
            stack.func_77980_a(level, this.interactingPlayer, this.takeCount);
            if (!level.field_72995_K && this.field_75224_c instanceof BlastFurnaceTileEntity) {
                BlastFurnaceTileEntity tileEntity = (BlastFurnaceTileEntity)this.field_75224_c;
                tileEntity.awardUsedRecipeAndAddExp(this.interactingPlayer);
            }
            this.takeCount = 0;
            BasicEventHooks.firePlayerSmeltedEvent((PlayerEntity)this.interactingPlayer, (ItemStack)stack);
        }
    }
}

